/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.blockentity.StoneRollerBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class StoneRollerBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);

    public StoneRollerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public void m_6810_(BlockState pState, Level worldIn, BlockPos pos, BlockState pNewState, boolean isMoving) {
        if (!pNewState.m_60713_((Block)this)) {
            this.dropItems(worldIn, pos);
        }
        super.m_6810_(pState, worldIn, pos, pNewState, isMoving);
    }

    private void dropItems(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null) {
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(inv -> {
                for (int i = inv.getSlots() - 1; i >= 0; --i) {
                    if (inv.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                    ((IItemHandlerModifiable)inv).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(inv -> {
                for (int i = inv.getSlots() - 1; i >= 0; --i) {
                    if (inv.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                    ((IItemHandlerModifiable)inv).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te;
        if (!worldIn.m_5776_() && (te = worldIn.m_7702_(pos)) instanceof StoneRollerBlockEntity) {
            if (!playerIn.m_6144_()) {
                if (!playerIn.m_21120_(handIn).m_41619_()) {
                    return te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).map(container -> {
                        playerIn.m_21008_(handIn, container.insertItem(0, playerIn.m_21120_(handIn), false));
                        return InteractionResult.SUCCESS;
                    }).orElse(InteractionResult.FAIL);
                }
                te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(container -> {
                    for (int i = 0; i <= 2; ++i) {
                        ItemStack itemStack = container.extractItem(i, 64, false);
                        if (itemStack.m_41619_()) continue;
                        Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                    }
                });
                te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(container -> {
                    if (((StoneRollerBlockEntity)te).isCompleted()) {
                        ItemStack itemStack = container.extractItem(0, container.getStackInSlot(0).m_41613_(), false);
                        Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                    }
                });
                return InteractionResult.SUCCESS;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)((MenuProvider)te), (BlockPos)te.m_58899_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new StoneRollerBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return NormalHorizontalBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegister.STONE_ROLLER_TYPE.get(), StoneRollerBlockEntity::tick);
    }
}

